#include <AT91SAM7X256.h>
#include <RTL.h>
#include <lib_AT91SAM7X256.H>
#include <delay.h>

#define PORTRAIT 
#define TFTLCD_DATAPORT_B             
#define TFTLCD_DATAPORT_OFFSET      0
#define TFTLCD_CONTROLPORT_A          
#define TFTLCD_RST                  24
#define TFTLCD_RS                   25
#define TFTLCD_CS                   26
#define TFTLCD_WR                   19
#define TFTLCD_RD                   20                              

#include "tftlcd_functions.c"
#include <stdio.h>

int x1=10,y1=10,x2=10,y2=280,x3=200,y3=50,x4=230,y4=310;
int x_1=3,y_1=3;
int x_2=3,y_2=-3;
int x_3=-3,y_3=3;
int x_4=-3,y_4=-3;

int fps=0,time=0,ti=0;
char lcd_buffer[20];

__task void task_init(void);
__task void task1(void);
__task void task2(void);
__task void task3(void);
__task void task4(void);
__task void task_fps(void);
__task void task_intel(void);

int main()
{
   
   os_sys_init(task_init);
   while(1){}
   return 0;
}

__task void task_init(void)
{
	tftlcd_init();
	os_tsk_create(task_intel, 1);
   	os_tsk_create(task1, 1);
	os_tsk_create(task2, 1);
	os_tsk_create(task3, 1);
	os_tsk_create(task4, 1);
	os_tsk_create(task_fps,2);
	os_tsk_delete_self();     
}

__task void task1(void)
{
   while(1){
		tftlcd_draw_circle(x1,y1,10,1,WHITE);
   		x1+=x_1;
		if(x1>234 || x1<5) x_1*=-1;
		y1+=y_1;
		if(y1>314 || y1<5) y_1*=-1;
		tftlcd_draw_circle(x1,y1,10,1,RED); 
		fps++;
		os_tsk_pass();	
   }
}

__task void task2(void)
{

   while(1){
		tftlcd_draw_circle(x2,y2,10,1,WHITE);
   		x2+=x_2;
		if(x2>234 || x2<5) x_2*=-1;
		y2+=y_2;
		if(y2>314 || y2<5) y_2*=-1; 
		tftlcd_draw_circle(x2,y2,10,1,GREEN);
		fps++;
		os_tsk_pass();		
   }
}

__task void task3(void)
{
   while(1){
		tftlcd_draw_circle(x3,y3,10,1,WHITE);
   		x3+=x_3;
		if(x3>234 || x3<5) x_3*=-1;
		y3+=y_3;
		if(y3>314 || y3<5) y_3*=-1; 
		tftlcd_draw_circle(x3,y3,10,1,BLUE);
		fps++;
		os_tsk_pass();		
   }
}

__task void task4(void)
{
   while(1){
		tftlcd_draw_circle(x4,y4,10,1,WHITE);
   		x4+=x_4;
		if(x4>234 || x4<5) x_4*=-1;
		y4+=y_4;
		if(y4>314 || y4<5) y_4*=-1; 
		tftlcd_draw_circle(x4,y4,10,1,BLACK);
		fps++;
		os_tsk_pass();		
   }
}

__task void task_fps(void)
{
   os_itv_set(100);
   while(1){
   		os_itv_wait();
		sprintf(lcd_buffer,"FPS=%u   ",fps/4);	// 4 = number of balls
		tftlcd_gotoxy(0,19);
		tftlcd_puts(lcd_buffer,BLACK,WHITE,0);
		fps=0;
	}
}

__task void task_intel(void)
{
	static int x_,y_;
	while(1){
		if (((x1+20>x2 && x1-20<x2))&&((y1+20>y2 && y1-20<y2))) {
		   	x_  = x_1 , y_  = y_1;
			x_1 = x_2 , y_1 = y_2;
			x_2 = x_  , y_2 = y_;			
		}
		
		if (((x3+20>x4 && x3-20<x4))&&((y3+20>y4 && y3-20<y4))) {
		   	x_  = x_3 , y_  = y_3;
			x_3 = x_4 , y_3 = y_4;
			x_4 = x_  , y_4 = y_;			
		}

		if (((x3+20>x1 && x3-20<x1))&&((y3+20>y1 && y3-20<y1))) {
		   	x_  = x_3 , y_  = y_3;
			x_3 = x_1 , y_3 = y_1;
			x_1 = x_  , y_1 = y_;			
		}

		if (((x2+20>x4 && x2-20<x4))&&((y2+20>y4 && y2-20<y4))) {
		   	x_  = x_2 , y_  = y_2;
			x_2 = x_4 , y_2 = y_4;
			x_4 = x_  , y_4 = y_;			
		}

		if (((x3+20>x2 && x3-20<x2))&&((y3+20>y2 && y3-20<y2))) {
		   	x_  = x_3 , y_  = y_3;
			x_3 = x_2 , y_3 = y_2;
			x_2 = x_  , y_2 = y_;			
		}

		if (((x1+20>x4 && x1-20<x4))&&((y1+20>y4 && y1-20<y4))) {
		   	x_  = x_1 , y_  = y_1;
			x_1 = x_4 , y_1 = y_4;
			x_4 = x_  , y_4 = y_;			
		}	
		os_tsk_pass();
	}
}

